package Mix::Stats;
# (c) 2002 Peter Palfrader <peter@palfrader.org>
# $Id: Keyring.pm,v 1.1 2002/05/21 02:22:05 weasel Exp $

=pod
=head1 NAME

Mix::Stats - handle mixmaster stats

=head1 SYNOPSIS

FIXME doc

=head1 DESCRIPTION

FIXME doc

=cut

use strict;
use lib '../../../../lib', 'lib', '../lib';
use Carp qw{carp croak confess};
use vars qw{$VERSION};

($VERSION) = '$Revision: 1.1 $' =~ /\s(\d+\.\d+)\s/;


my @MLISTS = (
	$ENV{'HOME'}.'/.mix/mlist2.txt',
	$ENV{'HOME'}.'/.mix/mlist2.html',
	$ENV{'HOME'}.'/.mix/mlist.txt',
	$ENV{'HOME'}.'/.mix/mlist.html',
	$ENV{'HOME'}.'/Mix/mlist2.txt',
	$ENV{'HOME'}.'/Mix/mlist2.html',
	$ENV{'HOME'}.'/Mix/mlist.txt',
	$ENV{'HOME'}.'/Mix/mlist.html',
	'/var/lib/mix/mlist2.txt',
	'/var/lib/mix/mlist2.html',
	'/var/lib/mix/mlist.txt',
	'/var/lib/mix/mlist.html',
	'/etc/mix/mlist2.txt',
	'/etc/mix/mlist2.html'
	'/etc/mix/mlist.txt',
	'/etc/mix/mlist.html'
	);

=pod

=over

=item B<new> ()

The constructor. Takes a hash, usually with one argument: I<Filename>.
I<Filename> indicates a file from which the mixmaster stats should be read.
Ususally this file is called mlist or mlist2.

=over

=item Filename

Name of the file that contains the stats.

=over

For importing the stats, I<read_file> is called.

=back

=cut

sub new {
	my ($class, %params) = @_;
	my $self = {};
	bless $self, $class;

	if (defined $params{'Filename'}) {
		$self->read_file($params{'Filename'});
	} else {
		for my $filename (@MLISTS) {
			if (-e $filename) {
				$self->read_file($filename);
				last;
			};
		};
	};
	unless (scalar keys %{$self->{'remailers'}}) {
		warn ("No remailer stats found\n");
	}
	return $self;
};

=pod

=item B<read_mlist> (I<ARG>)

Reads all stats from the mlist passed as ARG and adds it to the stats object.

=over

I<ARG> may be either a file descriptor (reference to a GLOB) or a reference to
an array.

=back

=cut

sub read_mlist($@) {
	my ($self, $arg) = @_;

	my $lines;
	if (ref($arg) eq 'ARRAY') {
		$lines = $arg;
	} elsif (defined fileno($arg)) {
		@$lines = <$arg>;
	};

	my @lines = @$lines;

  	my %stats;
	my $statsversion;
	my $statsdate;

  	while (@lines) {
		my $line = @lines[0];
  		chomp($line);
		$line =~ s/^\s*//;
		$line =~ s/\s*$//;
		if ($line =~ /^Stats-Version: (.*)/) {
			$statsversion = $1;
			last;
		} elsif ($line =~ /^Last update: (.*)/) {
			$statsversion = 1;
			$statsdate = $1;
			last;
		} else {
			shift @lines;
		}
  	}

	if (defined $statsversion) {
		if ($statsversion eq '2.0' ) {
			my $line = @lines[0];
			chomp($line);
			$line =~ s/^\s*//;
			$line =~ s/\s*$//;
			if (/^Generated: (.*)/) {
				$statsdate = $1;
			} else {
				carp ("Statsformat (v$statsversion) violation");
			};
		} elsif ($statsversion == 1) {

		} else {
			carp ("Don't know about statsversion $statsversion");
		}
	} else {
		carp ("Could not parse stats");
	}
};

=pod

=item B<read_file> (I<filename>)

Opens the file given by I<filename> and calls I<read_mlist> to import all stats from the given file.

=cut


sub read_file($$) {
	my ($self, $filename) = @_;
	open (MLIST, $filename) or croak ("Cannot open mlist '$filename': $!");
	$self->read_mlist(*MLIST);
	close(MLIST);
};


#  =item B<get_type2list> ()
#  
#  Returns a string with the type2.list.
#  
#  =cut
#  
#  sub get_type2list($) {
#  	my ($self) = @_;
#  
#  	my $result = '';
#  	for my $remailer (sort keys %{$self->{'remailers'}}) {
#  		$result .= $self->{'remailers'}->{$remailer}->get_type2_line();
#  	};
#  
#  	return $result;
#  };

=pod

=back

=head1 AUTHOR

Peter Palfrader E<lt>peter@palfrader.orgE<gt>

=head1 FILES

I<$HOME/.mix/mlist{2,}.{txt,html}>, I<$HOME/Mix/mlist{2,}.{txt,html}>,
I</var/lib/mix/mlist{2,}.{txt,html}>,
and I</etc/mix/mlist{2,}.{txt,html}> are tried in that order if no I<Filename>
argument is passed to I<new>.

=head1 BUGS
 
Please report them to the author.

=head1 SEE ALSO

=over

=item Mixmaster Protocol, Version 2 <draft-moeller-v2-01.txt>

=item mix(1)

=item news:alt.privacy.anon-server

=item Mix

=back

=cut
1;
