/* readsubs for Webinterface for Unix Listproc V 0.1
 *
 * Copyright (C) 1999 Dieter Baron <dillo@danbala.ifoer.tuwien.ac.at>
 *                    Peter Palfrader <ppalfrad@cosy.sbg.ac.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define SUBSCRIBERS_FILE "/servers/listserv/lists/TCG/.subscribers"

char *prg;

int
main(int argc, char **argv)
{
    FILE *f;
    char line[8192];

    prg = argv[0];

    if ((f=fopen(SUBSCRIBERS_FILE, "r")) == NULL) {
	fprintf(stderr, "%s: can't open subscribers file `%s': %s\n",
		prg, SUBSCRIBERS_FILE, strerror(errno));
	exit(1);
    }

    while (fgets(line, 8192, f) && !ferror(stdout)) {
	fputs(line, stdout);
    }
    
    if (ferror(f)) {
	fprintf(stderr, "%s: read error on subscribers file `%s': %s\n",
		prg, SUBSCRIBERS_FILE, strerror(errno));
	exit(1);
    }
    fflush(stdout);
    if (ferror(stdout)) {
	fprintf(stderr, "%s: write error on stdout: %s\n",
		prg, strerror(errno));
	exit(1);
    }

    fclose(f);
    exit(0);
}
